package com.agilex.healthcare.veteranappointment.domain;

import com.agilex.healthcare.mobilehealthplatform.domain.DomainTransferObject;
import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;
import com.agilex.healthcare.veteranappointment.serializer.JsonDateSerializer;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Date;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "appointmentRequestDetailCode", namespace = Namespace.VeteranAppointmentRequest)
public class VARAppointmentRequestDetailCode extends DomainTransferObject implements Comparable<VARAppointmentRequestDetailCode> {
	private static final long serialVersionUID = -7731727560159684968L;

	@XmlElement
	private String appointmentRequestDetailCodeId;

	@JsonSerialize(using = JsonDateSerializer.class)
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "MM/dd/yyyy HH:mm:ss")
	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date createdDate;
	
	@XmlElement
	private VARDetailCode detailCode;
	
	@XmlElement
	private String userId;
	
	public String getAppointmentRequestDetailCodeId() {
		return appointmentRequestDetailCodeId;
	}

	public void setAppointmentRequestDetailCodeId(String appointmentRequestDetailCodeId) {
		this.appointmentRequestDetailCodeId = appointmentRequestDetailCodeId;
	}
	
	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public VARDetailCode getDetailCode() {
		return detailCode;
	}

	public void setDetailCode(VARDetailCode detailCode) {
		this.detailCode = detailCode;
	}

	@Override
	public int compareTo(VARAppointmentRequestDetailCode that) {
		int result = 0;
		
		if (this.getCreatedDate().before(that.getCreatedDate())) {
			result = 1;
		} else if (this.getCreatedDate().before(that.getCreatedDate())) {
			result = -1;
		}
		
		return result;
	}
}
